define([
    'underscore',
    'modules/new-appointment-request/resources/common/request-limit/model',
], function(_, Model) {
    'use strict';

    describe('Recent Visit Model', function() {
        var model;

        beforeEach(function() {
            model = new Model();
        });

        describe('Fetch', function() {
            beforeEach(function() {
                spyOn(model, 'fetch').and.callFake(_.noop);
            });

            it('calls fetch with the correct params', function() {
                var institutionCode = '123AB';
                var clinicalService = '321';
                var args;

                model.fetchRequestLimit(institutionCode, clinicalService);
                args = model.fetch.calls.first().args[0];

                expect(args.data).not.toBeUndefined();
                expect(args.data['clinical-service']).toBe(clinicalService);
                expect(args.data['institution-code']).toBe(institutionCode);
            });
        });

        describe('hasRequestsLeft', function() {
            it('returns true when there is no limit', function() {
                var data = {requestLimit: 0, numberOfRequests: 0};

                model.set(data);
                expect(model.hasRequestsLeft()).toBeTruthy();
            });

            it('returns true when there is a limit but it is not met', function() {
                var data = {requestLimit: 3, numberOfRequests: 1};

                model.set(data);
                expect(model.hasRequestsLeft()).toBeTruthy();
            });

            it('return false when there is a limit and it is exceeded', function() {
                var data = {requestLimit: 3, numberOfRequests: 5};

                model.set(data);
                expect(model.hasRequestsLeft()).toBeFalsy();
            });
        });


        it('generates the correct url', function() {
            var expected = 'base-url/VeteranAppointmentRequestService/v4/rest/direct-scheduling/patient/assigning-authority/testpatient/request-limit';
            var output = model.url();

            expect(output).toBe(expected);
        });
    });
});
